unit Global;

interface

uses
  System.Collections, System.ComponentModel,
  System.Web, System.Web.SessionState, Borland.Data.Provider, Borland.Data.Common,
  System.Data, System.Configuration;

type
  TGlobal = class(System.Web.HttpApplication)
  {$REGION 'Designer Managed Code'}
  strict private
    bdpConn: Borland.Data.Provider.BdpConnection;
    procedure InitializeComponent;
  {$ENDREGION}
  strict protected
    procedure Application_Start(sender: System.Object; e: EventArgs);
    procedure Session_Start(sender: System.Object; e: EventArgs);
    procedure Application_BeginRequest(sender: System.Object; e: EventArgs);
    procedure Application_EndRequest(sender: System.Object; e: EventArgs);
    procedure Application_AuthenticateRequest(sender: System.Object; e: EventArgs);
    procedure Application_Error(sender: System.Object; e: EventArgs);
    procedure Session_End(sender: System.Object; e: EventArgs);
    procedure Application_End(sender: System.Object; e: EventArgs);
  private
    { Private Declarations }
    procedure CreateNewItemsView;
    function ExecuteCommand( SQLStr : string ): Boolean;
  public
    constructor Create;
  end;

implementation

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TGlobal.InitializeComponent;
var
  configurationAppSettings: System.Configuration.AppSettingsReader;
begin
  configurationAppSettings := System.Configuration.AppSettingsReader.Create;
  Self.bdpConn := Borland.Data.Provider.BdpConnection.Create;
  // 
  // bdpConn
  // 
  Self.bdpConn.ConnectionOptions := '';
  Self.bdpConn.ConnectionString := (string(configurationAppSettings.GetValue('C' +
    'onnectionString', TypeOf(string))));
end;
{$ENDREGION}

constructor TGlobal.Create;
begin
  inherited;
  //
  // Required for Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TGlobal.Application_Start(sender: System.Object; e: EventArgs);
begin

end;

procedure TGlobal.Session_Start(sender: System.Object; e: EventArgs);
begin
  CreateNewItemsView;
end;

procedure TGlobal.Application_BeginRequest(sender: System.Object; e: EventArgs);
begin

end;

procedure TGlobal.Application_EndRequest(sender: System.Object; e: EventArgs);
begin

end;

procedure TGlobal.Application_AuthenticateRequest(sender: System.Object; e: EventArgs);
begin

end;

procedure TGlobal.Application_Error(sender: System.Object; e: EventArgs);
begin

end;

procedure TGlobal.Session_End(sender: System.Object; e: EventArgs);
var
  SQLStr : String;
begin
  SQLStr := 'DROP VIEW NEWITEMS';
  ExecuteCommand(SQLStr);
end;

procedure TGlobal.Application_End(sender: System.Object; e: EventArgs);
begin

end;

procedure TGlobal.CreateNewItemsView;
var
  SQLStr : String;
begin
  SQLStr := 'DROP VIEW NEWITEMS';
  ExecuteCommand(SQLStr);
  SQLStr := 'CREATE VIEW NEWITEMS AS SELECT I.ORDERNO, I.ITEMNO, I.PARTNO, I.QTY, I.DISCOUNT, P.DESCRIPTION, P.COST, O.TAXRATE, O.FREIGHT, O.AMOUNTPAID FROM ITEMS I, PARTS P, ORDERS O WHERE (I.PARTNO = P.PARTNO) AND (I.ORDERNO = O.ORDERNO)';
  ExecuteCommand(SQLStr);
end;

function TGlobal.ExecuteCommand( SQLStr : string ): Boolean;
var
  bdpCmd : BdpCommand;
  bdpTrans : BdpTransaction;
begin
  Result := True;
  bdpCmd := nil;
  bdpTrans := nil;
  try
  begin
    if bdpConn.State <> ConnectionState.Open then
      bdpConn.Open();
    bdpCmd := BdpCommand.Create( SQLStr, bdpConn );
    bdpTrans := bdpConn.BeginTransaction();
    bdpCmd.ExecuteNonQuery();
    bdpTrans.Commit();
    bdpCmd.Close;
    bdpConn.Close;
  end;
  except
    on e : Exception do
    begin
      Result := False;
      if (bdpTrans <> nil) then
        bdpTrans.Rollback;
      if (bdpCmd <> nil) then
        bdpCmd.Close;
      if (bdpConn <> nil) then
        bdpConn.Close;
    end;
  end;
end;

end.
